#!/bin/bash

CONFIG="/opt/pos/etc/config.ini"
STATION_NUMBER=`cat /opt/pos/etc/config.ini | grep STATION_NUMBER | cut -f2 -d=`
X64_ACTIVE=`cat $CONFIG | grep "X64_ACTIVE" | cut -f2 -d=`
KILLED=0
DARUMA_PRINTER_PORT=`cat /opt/pos/etc/config.ini | grep "DARUMA_PRINTER_PORT=" | cut -f2 -d=`
HAS_MOBILE_DEVICES=`cat $CONFIG | grep MOBILE_DEVICES | grep -v grep | grep 1`

if [ "$DARUMA_PRINTER_PORT" != "" ]; then
  /opt/pos/common/addons/daruma/app &
fi

for pid in `ps xa | grep "perl /opt/pos/common/bin/devices_handler.pl" | grep -v grep | awk '{print $1;}'`; do
  KILLED=1
  kill -TERM $pid
done

for pid in `ps xa | grep "perl - Proc" | grep -v grep | awk '{print $1;}'`; do
  KILLED=1
  kill -9 $pid
done

if [ "$X64_ACTIVE" = "1" ]; then
  for pid in `ps xa | grep "x64\.gambas" | grep -v grep | awk '{print $1;}'`; do
    kill -9 $pid
  done
fi

for pid in `ps xa | grep "perl - Proc" | grep -v grep | awk '{print $1;}'`; do
  KILLED=1
  kill -9 $pid
done

if [ "$HAS_MOBILE_DEVICES" != "" ]; then
  if [ ! -e "/usr/bin/starman" ]; then
    # restart mobile if it's running
    MOBILE_PID=`ps -eo pid,args | grep perl | grep mobile  | grep -v grep | cut -c1-6`

    if [ "$MOBILE_PID" != "" ]; then
      kill -9 $MOBILE_PID
      /opt/pos/common/addons/mobile/bin/app.pl --daemon
    fi
  else
    for pid in `ps xa | grep plackup | grep -v grep | awk '{ print $1 }'`; do
      kill -9 $pid
    done

    for pid in `ps xa | grep starman | grep -v grep | awk '{ print $1 }'`; do
      kill -9 $pid
    done

    /opt/pos/common/addons/mobile/bin/run &
  fi
fi

if [ "$STATION_NUMBER" = "0" ]; then
  rm -rf /opt/pos/server/data/registered_printers/*
  rm -rf /opt/pos/server/data/registered_stations/*
fi

/opt/pos/common/bin/devices_handler.pl &


