#!/usr/bin/perl

use strict;
use warnings;
use FindBin qw( $Bin );
use lib "$Bin/../../lib";
use Data::Dumper;
use App::POS::Config;

my $cfg = App::POS::Config->new( file => "/opt/pos/etc/config.ini" );
my $info = $cfg->load_fixed();

if (! exists $info->{STATION_NUMBER}) {
  die "Missing 'STATION_NUMBER' in config.ini file...\n";
}

$info->{STATION_NUMBER} ||= 0;

# if we're in a station, read config from server
if ($info->{STATION_NUMBER} != 0 && -e "/shares/pos/etc/config.ini") {
  my $cfg2 = App::POS::Config->new( file => "/shares/pos/etc/config.ini" );
  $info = $cfg2->load_fixed();
}

$info->{PrintingZones}->{Zone} ||= [];

foreach (sort { $a->{Name} cmp $b->{Name} } @{ $info->{PrintingZones}->{Zone} }) {
  print $_->{Name}."\n";
}

