#!/bin/bash

CUSTOM_IP=$1
POS_HARDLOCK=""
HARDLOCK_PATH=""

if [ -e "/opt/pos/.machine_id" ]; then
  POS_HARDLOCK=`cat "/opt/pos/.machine_id"`
  HARDLOCK_PATH=`cat "/opt/pos/.hardlock"`
  HARDLOCK_PATH="/media/$HARDLOCK_PATH"
else
  for dir in `ls /media/`; do
    if [ -d "/media/$dir" ] && [ -d "/media/$dir/pos" ] && [ -e "/media/$dir/pos/hardlock" ]; then
      TMP=`/opt/pos/common/bin/device_id "/media/$dir" 2> /dev/null`

      if [ "$TMP" != "" ]; then
        HARDLOCK_PATH="/media/$dir"
        POS_HARDLOCK=$TMP
      fi
    fi
  done
fi

if [ "$POS_HARDLOCK" = "" ]; then
  echo "$0) HARDLOCK ISN'T PRESENT, ABORTING..."
  #exit
fi

CONFIG="/opt/pos/etc/config.ini"
DATA_DIR="/opt/pos/common/data"
AREAS_DIR="/opt/pos/server/data/areas"
SALES_TO_NETWORK_DIR="/opt/pos/server/data/replicate_network"
STATION_NUMBER=`cat /opt/pos/etc/config.ini | grep STATION_NUMBER | cut -f2 -d=`
MACHINE_ID=`/opt/pos/common/bin/machine_id`
HAS_NETWORK=`/opt/pos/common/bin/has_network`
VPN_IP=`/opt/pos/common/bin/vpn_ip_address.sh`

SALES_TO_NETWORK=`cat $CONFIG | grep SALES_TO_NETWORK | grep -v grep | grep 1`

if [ ! -d "$DATA_DIR" ]; then
  mkdir -p "$DATA_DIR"
fi

#
# Server Machine
#
if [ "$STATION_NUMBER" = "0" ]; then
  # collect files to send to network
  if [ "$SALES_TO_NETWORK" != "" ]; then
    if [ -d "$SALES_TO_NETWORK_DIR" ]; then
      FILES=`ls $SALES_TO_NETWORK_DIR`

      if [ "$FILES" != "" ]; then
        DATE=`date +%s`
        DEST="$DATA_DIR/sales_$$_$DATE.zip"
        echo "WILL ADD $DEST"
        zip -q -D -m $DEST $SALES_TO_NETWORK_DIR/* > /dev/null 2> /dev/null
      fi
    fi
  fi

  # mirror server to hardlock, if active
  if [ -e "${HARDLOCK_PATH}/pos/mirror.txt" ]; then
    if [ ! -d "" ]; then
      mkdir -p "${HARDLOCK_PATH}/pos/mirror"
    fi

    IN_MIRROR=`ps xa | grep "pos/mirror" | grep -v grep`

    if [ "$IN_MIRROR" = "" ]; then
      echo "WILL MIRROR TO HARDLOCK..."
      rsync --delete -a /opt/pos/ "${HARDLOCK_PATH}/pos/mirror"
    fi
  fi

  if [ "$HAS_NETWORK" != "NO" ]; then
    # send data files
    for file in `ls $DATA_DIR/DB_*.xls $DATA_DIR/sales_*.zip $DATA_DIR/backup_*.zip 2> /dev/null`; do
      echo "WILL SEND $file TO SERVER"
      RES=`curl -F "machine_id=$MACHINE_ID" -F "fileupload=@$file" http://releases.ptcert.com/api/machines/file_receive 2> /dev/null`

      if [ "$RES" = "OK" ]; then
        rm -rf $file
      fi

      #wget -O /tmp/remote.xls http://releases.ptcert.com/api/machines/remote_content?machine_id=$MACHINE_ID

      #if [ -s "/tmp/remote.xls" ]; then
      #  /opt/pos/common/skins/PT/db_import.pl /tmp/remote.xls
      # 
      #fi
    done
  fi
#
# Station Machine
#
else
  # mirror server into a folder in station
  SERVER_SYNC_RUNNING=`ps xa | grep server_sync | grep -v grep`

  if [ "$SERVER_SYNC_RUNNING" = "" ]; then
    /opt/pos/station/apps/server_sync.sh &
  fi
fi

if [ "$CUSTOM_IP" != "" ]; then
  VPN_IP="$CUSTOM_IP"
fi

# Ping Server
if [ "$HAS_NETWORK" != "NO" ]; then
  # ping server
  wget --timeout=5 -q -O /dev/null "http://releases.ptcert.com/api/machines/ping?machine_id=$MACHINE_ID&vpn_ip=$VPN_IP"
else
  echo "NO NETWORK..."
fi

