#!/bin/bash

HAS_NETWORK=`/opt/pos/common/bin/has_network`

# if we've network, net's try to find out if current time zone is the
# same of the network one

if [ "$HAS_NETWORK" = "YES" ]; then
  # configure timezone based on the country where the machine is installed
  CUR_TIMEZONE=`cat /etc/timezone`
  TIMEZONE=`wget -qO- http://ip-api.com/csv | cut -d, -f10`

  if [ "$TIMEZONE" != "" ]; then
    if [ "$TIMEZONE" != "$CUR_TIMEZONE" ]; then
      disk_rw
      echo $TIMEZONE > /etc/timezone
      dpkg-reconfigure --frontend noninteractive tzdata
      disk_ro
    fi
  fi

  # set the clock from ntp
  ntpdate -t 10 pool.ntp.org
fi

