#!/bin/bash

CONFIG="/opt/pos/etc/config.ini"
HAS_MOBILE_DEVICES=`cat $CONFIG | grep MOBILE_DEVICES | grep -v grep | grep 1`

if [ ! -e "/usr/sbin/nginx" ]; then
  apt-get -f install nginx
  apt-get clean
fi

if [ "$HAS_MOBILE_DEVICES" != "" ]; then
  echo "upstream pos_cluster {" > /etc/nginx/sites-available/default
  echo "  server 127.0.0.1:3000;" >> /etc/nginx/sites-available/default
  echo "}" >> /etc/nginx/sites-available/default
  echo "" >> /etc/nginx/sites-available/default
  echo "server {" >> /etc/nginx/sites-available/default
  echo "  listen   8080 default;" >> /etc/nginx/sites-available/default
  echo "  server_name  localhost;" >> /etc/nginx/sites-available/default
  echo "  keepalive_timeout 0;" >> /etc/nginx/sites-available/default
  echo "" >> /etc/nginx/sites-available/default
  echo "  location / {" >> /etc/nginx/sites-available/default
  echo "    proxy_pass http://pos_cluster;" >> /etc/nginx/sites-available/default
  echo "  }" >> /etc/nginx/sites-available/default
  echo "" >> /etc/nginx/sites-available/default
  echo "  access_log  /dev/null;" >> /etc/nginx/sites-available/default
  echo "}" >> /etc/nginx/sites-available/default

  if [ ! -e "/usr/bin/starman" ]; then
    /etc/init.d/nginx restart

    # restart mobile if it's running
    MOBILE_PID=`ps -eo pid,args | grep perl | grep mobile  | grep -v grep | cut -c1-6`

    if [ "$MOBILE_PID" != "" ]; then
      kill -9 $MOBILE_PID
    fi

    /opt/pos/common/addons/mobile/bin/app.pl --daemon
  else
    /etc/init.d/nginx restart

    for pid in `ps xa | grep plackup | grep -v grep | awk '{ print $1 }'`; do
      kill -9 $pid
    done

    for pid in `ps xa | grep starman | grep -v grep | awk '{ print $1 }'`; do
      kill -9 $pid
    done

    /opt/pos/common/addons/mobile/bin/run &
  fi
else
  /etc/init.d/nginx stop
fi

