#!/bin/bash

#
# call stuff using the two minutes timer from UI
#

STATION_NUMBER=$1

CONFIG="/opt/pos/etc/config.ini"
STATION=`cat $CONFIG | grep "STATION_NUMBER=" | cut -f2 -d=`
SUGESTIONS=`cat $CONFIG | grep "PRODUCTS_SUGESTION=" | cut -f2 -d=`
SAFT_SEND_NETWORK=`cat $CONFIG | grep "SAFT_SEND_NETWORK=" | cut -f2 -d=`
INTERNET_SEND_EMAILS=`cat $CONFIG | grep "INTERNET_SEND_EMAILS=" | cut -f2 -d=`
SAFT_GENERATE_LOCALY=`cat $CONFIG | grep "SAFT_GENERATE_LOCALY=" | cut -f2 -d=`
USE_NETBO=`cat $CONFIG | grep "USE_NETBO=" | cut -f2 -d=`

if [ "$STATION" = "0" ]; then
  CUR_DATE=`date +%Y%m%d`
  CUR_YEAR=`date +%Y`
  CUR_DAY=`date +%d`
  CUR_MONTH=`date +%m`

  # netbo
  if [ "$USE_NETBO" = "1" ]; then
    TMP_DATE=`date +%Y%m%d_%H%M%S`
    mkdir -p /opt/pos/common/data/netbo 2> /dev/null
    echo 1 > /opt/pos/common/data/netbo/run.$TMP_DATE.txt
    find /opt/pos/common/data/netbo -type f -mmin +60 -delete
  fi

  # generate saft localy
  if [ "$SAFT_GENERATE_LOCALY" != "" ]; then
    if [ ! -d "/opt/pos/common/data/saft_to_hdd/$CUR_YEAR/$CUR_MONTH" ]; then
      mkdir -p "/opt/pos/common/data/saft_to_hdd/$CUR_YEAR/$CUR_MONTH"
    fi

    SYNCED_FILE="/opt/pos/common/data/saft_to_hdd/$CUR_YEAR/$CUR_MONTH/$CUR_DATE.txt"

    if [ ! -e "$SYNCED_FILE" ]; then
      /opt/pos/common/bin/saft_monthly "LOCALFOLDER"
      echo 1 > $SYNCED_FILE
    fi
  fi

  # handles emails
  if [ "$INTERNET_SEND_EMAILS" = "1" ]; then
    CUR_HOUR=`date +%H`

    # only check email sending after 7am
    if [ $CUR_HOUR -gt 7 ]; then
      if [ ! -d "/opt/pos/common/data/emails_send/$CUR_YEAR/$CUR_MONTH" ]; then
        mkdir -p "/opt/pos/common/data/emails_send/$CUR_YEAR/$CUR_MONTH"
      fi

      SYNCED_FILE="/opt/pos/common/data/emails_send/$CUR_YEAR/$CUR_MONTH/$CUR_DATE.txt"

      if [ ! -e "$SYNCED_FILE" ]; then
        /opt/pos/common/bin/emails_send
        echo 1 > $SYNCED_FILE
      fi
    fi
  fi

  # handles SAF-T sending
  if [ "$SAFT_SEND_NETWORK" = "1" ] || [ "$INTERNET_SEND_EMAILS" = "1" ]; then
    if [ "$CUR_DAY" != "1" ]; then
      if [ ! -d "/opt/pos/common/data/saft_to_network/$CUR_YEAR/$CUR_MONTH" ]; then
        mkdir -p "/opt/pos/common/data/saft_to_network/$CUR_YEAR/$CUR_MONTH"
      fi

      SYNCED_FILE="/opt/pos/common/data/saft_to_network/$CUR_YEAR/$CUR_MONTH/$CUR_DATE.txt"

      if [ ! -e "$SYNCED_FILE" ]; then
        /opt/pos/common/bin/saft_monthly
        echo 1 > $SYNCED_FILE
      fi
    fi
  fi

  # ping server
  /opt/pos/common/bin/ping_server.sh
fi

if [ "$SUGESTIONS" = "1" ]; then
  /opt/pos/server/apps/suggestions_generate.pl
fi

