#!/bin/bash

CONFIG="/opt/pos/etc/config.ini"
USE=`cat $CONFIG | grep USE_GRAPHICAL_CUSTOMER_DISPLAY | grep -v grep | grep 1`
AUTO_RELOCATE_WINDOWS=`cat /opt/pos/etc/config.ini | grep AUTO_RELOCATE_WINDOWS | cut -f2 -d=`

if [ "$1" != "" ]; then
  PID=`ps xa | grep graphical_display | grep -v grep | awk '{print $1}'`
  if [ "$PID" != "" ]; then
    kill -9 $PID
  fi

  exit
fi

if [ "$USE" != "" ]; then
  # dual screens
  if [ "$AUTO_RELOCATE_WINDOWS" = "1" ]; then
    /opt/pos/common/bin/relocate_windows &

    export DISPLAY=:0.0

    while [ 1 ]; do
      rm -rf /opt/pos/common/tmp/graphical_display 2> /dev/null
      mkdir /opt/pos/common/tmp/graphical_display

      /opt/pos/common/addons/graphical_display/app
      sleep 1
    done

  # usb screens
  else
    # keep the correct device in /etc/X11/xorg.conf
    CUR_SYS_DISPLAY_DEVICE=`dmesg | grep fb | grep "DisplayLink USB device" | cut -d":" -f2 | cut -d" " -f5 | uniq`
    CUR_XORG_DISPLAY_DEVICE=`cat /etc/X11/xorg.conf | grep "Option \"fbdev" | cut -d"\"" -f4`

    if [ "$CUR_SYS_DISPLAY_DEVICE" != "" ] && [ "$CUR_XORG_DISPLAY_DEVICE" != "" ]; then
      if [ "$CUR_SYS_DISPLAY_DEVICE" != "$CUR_XORG_DISPLAY_DEVICE" ]; then
        disk_rw
        /opt/pos/common/addons/graphical_display/xorg_install
        perl -pi -e "s|$CUR_XORG_DISPLAY_DEVICE|$CUR_SYS_DISPLAY_DEVICE|gm" /etc/X11/xorg.conf
        disk_ro
      fi
    fi

    export DISPLAY=:0.1

    while [ 1 ]; do
      rm -rf /opt/pos/common/tmp/graphical_display 2> /dev/null
      mkdir /opt/pos/common/tmp/graphical_display

      /opt/pos/common/addons/graphical_display/app
      sleep 1
    done
  fi
fi

