#!/bin/bash

CONFIG="/opt/pos/etc/config.ini"
MYLANG=`cat $CONFIG | grep LANG= | cut -f2 -d=`
SALES_TO_NETWORK=`cat $CONFIG | grep SALES_TO_NETWORK | grep -v grep | grep 1`

if [ "$SALES_TO_NETWORK" != "" ]; then
  HAS_NET=`/opt/pos/common/bin/has_network`

  if [ "$HAS_NET" = "YES" ]; then
    # send a backup to pos site
    /opt/pos/common/bin/backup /opt/pos /opt/pos/common/data
    # send a xls export to pos site
    /opt/pos/common/bin/db_export.pl --dest_folder=/opt/pos/common/data
  else
    echo "No network..."
  fi
else
  echo "SALES_TO_NETWORK isn't on in config.ini..."
fi

