#!/usr/bin/perl

use strict;
use warnings;
use Fcntl;
use Time::HiRes qw( sleep );

#
# PrepareDrawerPort
#

write_byte(0x2e, 0x87);
write_byte(0x2e, 0x87);
send_data(0x07, 0x07);
send_data(0x2a, 0xfc);
send_data(0xf1, 0xff);
send_data(0xf0, 0xfc);

#
# OpenDrawer
#

send_data(0xf1, 0xff);
send_data(0xf1, 0xfe);

#
# FinishDrawerPort
#

write_byte(0x2e, 0xaa);

#
# Functions
#

sub write_byte {
  my $port = shift;
  my $data = shift;

  my $show = chr($data);

  sysopen (PORT,"/dev/port",O_RDWR) || die "error on /dev/port: $!";
  binmode (PORT);
  sysseek (PORT,$port,0)|| die "seek_err\n";
  syswrite(PORT,$show)  || print "write_err while writing $data \n";
  close (PORT);
}

sub send_data {
  my $port = shift;
  my $data = shift;

  my $show = chr($data);

  write_byte(0x2e, $port);
  write_byte(0x2f, $data);
}

