#!/usr/bin/perl

use strict;
use warnings;
use Fcntl;
use Time::HiRes qw( sleep );

#
# PrepareDrawerPort
#

write_byte(0x2e, 0x87);
write_byte(0x2e, 0x87);
write_byte(0x2e, 0x07);
write_byte(0x2f, 0x09);
write_byte(0x2e, 0xf1);

#
# OpenDrawer
#

write_byte(0x2f, 0x53);
sleep 0.2;
write_byte(0x2f, 0x60);

#
# FinishDrawerPort
#

#write_byte(0x2e, 0xaa);

#
# Functions
#

sub write_byte {
  my $port = shift;
  my $data = shift;

  my $show = chr($data);

  sysopen (PORT,"/dev/port",O_RDWR) || die "error on /dev/port: $!";
  binmode (PORT);
  sysseek (PORT,$port,0)|| die "seek_err\n";
  syswrite(PORT,$show)  || print "write_err while writing $data \n";
  close (PORT);
}

sub send_data {
  my $port = shift;
  my $data = shift;

  my $show = chr($data);

  write_byte(0x2e, $port);
  write_byte(0x2f, $data);
}

