#!/bin/bash

COUNT=0
BAD=0
CPU_LIMIT=80

export DISPLAY=:0.0

LOG_FILENAME=/root/logs/cpu_load_monitor_log.log
GB_FILE_TIME=`stat -c %Y /opt/pos/common/bin/pos`
WATCHDOG_PORT=`cat /opt/pos/etc/config.ini | grep WATCHDOG_PORT | cut -f2 -d=`

while [ 1 ]; do
  CUR_DATE=`date +%Y%m%d_%H%M%S`

  DEVICES_RUNNING=`ps xa | grep devices_handler | grep -v grep`

  GB_PID=`ps xa | grep common/bin/pos | grep -v grep | awk '{ print $1 }'`

  if [ "$DEVICES_RUNNING" = "" ]; then
    echo "devices_handler is stopped, will start it..."
    /opt/pos/common/bin/devices_handler.pl &
  fi

  X_RUNNING=`ps xa | grep X | grep nolisten`

  #
  # watchdog handling
  #

  if [ "$WATCHDOG_PORT" != "" ]; then
    RES=`statserial -n $WATCHDOG_PORT > /tmp/watchdog_port.txt`
    cat /tmp/watchdog_port.txt | grep CTS > /tmp/watchdog_port2.txt
    RES=`cat /tmp/watchdog_port2.txt | grep 34H1`

    if [ "$RES" = "" ]; then
      echo "[$CUR_DATE] WATCHDOG - BUTTON TRIGGERED" >> /root/logs/watchdog.log


      if [ "$X_RUNNING" = "" ]; then
        echo "[$CUR_DATE] WATCHDOG - WILL CHECK DISK AND REBOOT" >> /root/logs/watchdog.log
        chkdsk
        reboot
      else
        echo "[$CUR_DATE] WATCHDOG - WILL KILL APP" >> /root/logs/watchdog.log
        kill -9 $GB_PID
      fi
    fi
  fi

  # monitor server
  STATION_NUMBER=`cat /opt/pos/etc/config.ini | grep STATION_NUMBER | cut -f2 -d=`

  # station monitor
  if [ "$STATION_NUMBER" != "0" ]; then
    FILES=""

    if [ -e "/usr/bin/timeout" ]; then
      FILES=`timeout 3 ls /shares/pos/etc 2> /dev/null`
    else
      FILES=`ls /shares/pos/etc 2> /dev/null`
    fi

    COOL=1

    # server is not mounted...
    if [ "$FILES" = "" ]; then
      COOL=0
      kill -9 $GB_PID
      echo "[$CUR_DATE] Server FILES error..." >> $LOG_FILENAME
      touch /tmp/server_error.txt

      if [ "$X_RUNNING" != "" ]; then
        xmessage -buttons ConfigEdit:2,Reboot:3,Retry:4 -timeout 10 "SERVER FILES ACCESS ERROR..."
        XRES="$?"

        if [ $XRES -eq 1 ]; then
          #perl -pi -e "s/STATION_NUMBER=\d+/STATION_NUMBER=0/" /opt/pos/etc/config.ini
          reboot
        elif [ $XRES -eq 2 ]; then
          /usr/bin/matchbox-keyboard &
          xterm -e nano /opt/pos/etc/config.ini
          killall -9 matchbox-keyboard
        elif [ $XRES -eq 3 ]; then
          /sbin/reboot
        elif [ $XRES -eq 4 ]; then
          /opt/pos/common/bin/restart_hardware_handler.sh
        else
          /opt/pos/common/bin/restart_hardware_handler.sh
        fi
      fi
    else
      if [ -e "/tmp/server_error.txt" ]; then
        rm -rf /tmp/server_error.txt
        /opt/pos/common/bin/restart_hardware_handler.sh
      fi
    fi

    if [ -e "/tmp/server_db_error.txt" ]; then
      COOL=0
      kill -9 $GB_PID
      echo "[$CUR_DATE] Server DB error..." >> $LOG_FILENAME

      if [ "$X_RUNNING" != "" ]; then
        xmessage -buttons ConfigEdit:2,Reboot:3,Retry:4 -timeout 10 "SERVER DATABASE ACCESS ERROR..."
        XRES="$?"

        if [ $XRES -eq 1 ]; then
          #perl -pi -e "s/STATION_NUMBER=\d+/STATION_NUMBER=0/" /opt/pos/etc/config.ini
          reboot
        elif [ $XRES -eq 2 ]; then
          /usr/bin/matchbox-keyboard &
          xterm -e nano /opt/pos/etc/config.ini
          killall -9 matchbox-keyboard
        elif [ $XRES -eq 3 ]; then
          /sbin/reboot
        elif [ $XRES -eq 4 ]; then
          /opt/pos/common/bin/restart_hardware_handler.sh
        else
          /opt/pos/common/bin/restart_hardware_handler.sh
        fi
      fi
    else
      if [ -e "/tmp/server_db_error.txt" ]; then
        rm -rf /tmp/server_db_error.txt
        /opt/pos/common/bin/restart_hardware_handler.sh
      fi
    fi

    #if [ $COOL -eq 1 ]; then
    #  echo "Server is cool..."
    #fi
  # server machine
  else
    if [ -e "/tmp/server_db_error.txt" ]; then
      kill -9 $GB_PID
      echo "Server DB error..."

      if [ "$X_RUNNING" != "" ]; then
        xmessage -buttons ConfigEdit:2,Reboot:3,Retry:4 -timeout 10 "SERVER DATABASE ACCESS ERROR..."
        XRES="$?"

        if [ $XRES -eq 1 ]; then
          #perl -pi -e "s/STATION_NUMBER=\d+/STATION_NUMBER=0/" /opt/pos/etc/config.ini
          reboot
        elif [ $XRES -eq 2 ]; then
          /usr/bin/matchbox-keyboard &
          xterm -e nano /opt/pos/etc/config.ini
          killall -9 matchbox-keyboard
        elif [ $XRES -eq 3 ]; then
          /sbin/reboot
        elif [ $XRES -eq 4 ]; then
          /opt/pos/common/bin/restart_hardware_handler.sh
        else
          /opt/pos/common/bin/restart_hardware_handler.sh
        fi
      fi
    else
      if [ -e "/tmp/server_db_error.txt" ]; then
        rm -rf /tmp/server_db_error.txt
        /opt/pos/common/bin/restart_hardware_handler.sh
      fi

      #echo "Database is cool..."
    fi
  fi

  # control cpu
  COUNT=`expr $COUNT + 1`

  TOP=`top -b -n 1 | grep $GB_PID | grep -v grep | sed -r "s/\x1B\[([0-9]{1,2}(;[0-9]{1,2})?)?[m|K]//g" | sed 's/^[ ]*//'`
  MYPID=`echo $TOP | awk '{print $1;}'`
  CPU=`echo $TOP | awk '{print $9;}'`

  if [ "$CPU" = "" ]; then
    CPU=0
  fi

  if [ $(echo "$CPU > $CPU_LIMIT"|bc) -eq 1 ]; then
    if [ $BAD -eq 0 ]; then
      COUNT=0
    fi

    BAD=1
  else
    COUNT=0
    BAD=0
  fi

  LOG_FILESIZE=0

  if [ -e $LOG_FILENAME ]; then
    LOG_FILESIZE=$(stat -c%s "$LOG_FILENAME")
  fi

  # log cleanup
  if [ $LOG_FILESIZE -gt 100000 ]; then
    echo "refresh" > $LOG_FILENAME
  fi

  echo "[$CUR_DATE] Loop COUNT=$COUNT, CPU=$CPU, BAD=$BAD, PID: $MYPID..." >> $LOG_FILENAME

  if [ $COUNT -eq 3 ]; then
    COUNT=0

    if [ $BAD -eq 1 ]; then
      BAD=0

      echo "WILL KILL: $MYPID"

      kill -9 $MYPID
      echo "[$CUR_DATE] CPU=$CPU" >> /root/logs/cpu_load_monitor_alert.log
    fi
  fi

  GB_FILE_TIME_NOW=`stat -c %Y /opt/pos/common/bin/pos`

  if [ "$GB_FILE_TIME" != "$GB_FILE_TIME_NOW" ]; then
    GB_FILE_TIME=$GB_FILE_TIME_NOW
    kill -9 $GB_PID
  fi

  sleep 15
done

